-- --------------------------------------------------------
-- Anfitrião:                    www.autoitec.com.br
-- Versão do servidor:           10.11.14-MariaDB-cll-lve - MariaDB Server
-- SO do servidor:               Linux
-- HeidiSQL Versão:              12.10.0.7000
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- A despejar estrutura da base de dados para autoitec_bancoparatestes
CREATE DATABASE IF NOT EXISTS `autoitec_bancoparatestes` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;
USE `autoitec_bancoparatestes`;

-- A despejar estrutura para tabela autoitec_bancoparatestes.tCliente
CREATE TABLE IF NOT EXISTS `tCliente` (
  `idCliente` bigint(20) NOT NULL,
  `nome` varchar(45) DEFAULT NULL,
  `endereco` varchar(150) DEFAULT NULL,
  `subRota` varchar(45) DEFAULT NULL,
  `pathLogo` varchar(45) DEFAULT NULL COMMENT 'Caminho do arquivo da logo\n\n',
  `responsavel` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL COMMENT 'email do responsavel pelo contrato\n',
  `telefone` varchar(45) DEFAULT NULL COMMENT 'telefonel do responsavel pelo contrato\n',
  PRIMARY KEY (`idCliente`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tDados
CREATE TABLE IF NOT EXISTS `tDados` (
  `idTransmissor` bigint(20) NOT NULL,
  `datahora` timestamp NULL DEFAULT NULL,
  `valor` float DEFAULT NULL,
  KEY `idx_tDados` (`idTransmissor`,`datahora`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tGondola
CREATE TABLE IF NOT EXISTS `tGondola` (
  `idGondola` int(11) NOT NULL AUTO_INCREMENT,
  `idLoja` int(11) NOT NULL,
  `descricao` varchar(45) DEFAULT NULL,
  `modelo` int(11) DEFAULT NULL COMMENT '1=Modelo 1 - Corredor (1x1) - ilha\n2=Modelo 2 - Canto parede (açougue)\n3=Modelo 3',
  `tamanho` int(11) DEFAULT NULL,
  `setor` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idGondola`),
  KEY `fk_tGondola_tCadastroLoja1_idx` (`idLoja`),
  CONSTRAINT `fk_tGondola_tCadastroLoja1` FOREIGN KEY (`idLoja`) REFERENCES `tLoja` (`idLoja`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tLoja
CREATE TABLE IF NOT EXISTS `tLoja` (
  `idLoja` int(11) NOT NULL AUTO_INCREMENT,
  `idCliente` bigint(20) NOT NULL,
  `cnpj` bigint(20) DEFAULT NULL,
  `descricao` varchar(45) DEFAULT NULL,
  `endereco` varchar(150) DEFAULT NULL,
  `pathLogo` varchar(45) DEFAULT NULL COMMENT 'Caminho do arquivo da logo\n\n',
  PRIMARY KEY (`idLoja`),
  KEY `fk_tLoja_tCliente1_idx` (`idCliente`),
  CONSTRAINT `fk_tLoja_tCliente1` FOREIGN KEY (`idCliente`) REFERENCES `tCliente` (`idCliente`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tMensagens
CREATE TABLE IF NOT EXISTS `tMensagens` (
  `idMensagem` bigint(20) NOT NULL AUTO_INCREMENT,
  `idUsuario` int(11) NOT NULL,
  `mensagem` text DEFAULT NULL,
  `criadoEm` timestamp NULL DEFAULT NULL,
  `enviadaEm` timestamp NULL DEFAULT NULL,
  `estado` tinyint(4) NOT NULL COMMENT '0=Não enviada\n1=Já enviada\n',
  PRIMARY KEY (`idMensagem`),
  KEY `idx_tMensagens` (`idUsuario`,`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tNotificao
CREATE TABLE IF NOT EXISTS `tNotificao` (
  `idNotificacao` bigint(20) NOT NULL AUTO_INCREMENT,
  `idLoja` bigint(20) DEFAULT NULL,
  `idGondola` bigint(20) DEFAULT NULL,
  `idTransmissor` bigint(20) DEFAULT NULL,
  `valor` float DEFAULT NULL,
  `alarme` tinyint(4) DEFAULT NULL,
  `criadoEm` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL COMMENT '0=Não cadastrado\n1=Já cadastrado',
  PRIMARY KEY (`idNotificacao`),
  KEY `idx_tNotificacao` (`idLoja`,`idGondola`,`idTransmissor`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tTransmissor
CREATE TABLE IF NOT EXISTS `tTransmissor` (
  `idTransmissor` bigint(20) NOT NULL,
  `idGondola` int(11) NOT NULL,
  `posicao` int(11) DEFAULT NULL,
  `descricao` varchar(45) DEFAULT NULL,
  `codigo` varchar(45) DEFAULT NULL,
  `caminho` varchar(45) DEFAULT NULL,
  `tipo` int(11) DEFAULT NULL COMMENT 'ºC\n0 = -18 a -12\n1 = -12 a -5\n2 = -5 a 0\n3 = 0 a 5\n4 = 0 a 10\n5 = até 16\n6 = acima de 16',
  `alarmeHH` float DEFAULT NULL,
  `alarmeH` float DEFAULT NULL,
  `alarmeL` float DEFAULT NULL,
  `alarmeLL` float DEFAULT NULL,
  `histerese` float DEFAULT NULL,
  `notificar` float DEFAULT NULL,
  `renotificar` float DEFAULT NULL COMMENT 'tempo h para renotificar em caso de alarme',
  `estado` int(11) DEFAULT NULL COMMENT 'BIT\n  0 - 1=Bateria Fraca/0=Bateria OK\n  1 - 1=Manutenção\n  2 - 1=Inibir Alarmes\n  3 - 1=Notificado\n',
  `nextNotificacao` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idTransmissor`),
  KEY `fk_tTrasmissor_tGondola1_idx` (`idGondola`),
  CONSTRAINT `fk_tTrasmissor_tGondola1` FOREIGN KEY (`idGondola`) REFERENCES `tGondola` (`idGondola`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tUsuario
CREATE TABLE IF NOT EXISTS `tUsuario` (
  `idUsuario` int(11) NOT NULL AUTO_INCREMENT,
  `senha` varchar(128) DEFAULT NULL,
  `nome` varchar(45) DEFAULT NULL,
  `sobrenome` varchar(45) DEFAULT NULL,
  `setor` varchar(45) DEFAULT NULL,
  `notificar` int(11) DEFAULT NULL COMMENT 'B  DESC\n0  1=Enviar telegram\n1  1=Enviar email\n2  1=SMS',
  `idTelegram` bigint(20) DEFAULT NULL,
  `telefone` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `nivelAcesso` int(11) DEFAULT NULL,
  PRIMARY KEY (`idUsuario`),
  UNIQUE KEY `email_UNIQUE` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

-- A despejar estrutura para tabela autoitec_bancoparatestes.tUsuarioLoja
CREATE TABLE IF NOT EXISTS `tUsuarioLoja` (
  `idUsuario` int(11) NOT NULL,
  `idLoja` int(11) NOT NULL,
  PRIMARY KEY (`idUsuario`,`idLoja`),
  KEY `fk_tUsuario_has_tLoja_tLoja1_idx` (`idLoja`),
  KEY `fk_tUsuario_has_tLoja_tUsuario1_idx` (`idUsuario`),
  CONSTRAINT `fk_tUsuario_has_tLoja_tLoja1` FOREIGN KEY (`idLoja`) REFERENCES `tLoja` (`idLoja`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tUsuario_has_tLoja_tUsuario1` FOREIGN KEY (`idUsuario`) REFERENCES `tUsuario` (`idUsuario`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Exportação de dados não seleccionada.

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
