<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
$action = $_GET['action'] ?? $_POST['action'] ?? null;
$token = $_POST['form_token'] ?? $_GET['form_token'] ?? null;

if (in_array($action, ['create_cliente','create_loja','create_gondola','create_transmissor'])) {
    if (!validate_form_token($token)) {
        die('Erro: token inválido ou formulário já enviado (prevenção duplicado).');
    }
}

function pkInfo($pdo, $table) {
    $col = $pdo->query("SHOW COLUMNS FROM {$table} WHERE `Key`='PRI'")->fetch();
    if (!$col) return null;
    return ['pk'=>$col['Field'], 'ai'=>stripos($col['Extra'] ?? '', 'auto_increment') !== false];
}

// create_cliente
if ($action === 'create_cliente') {
    $stmt = $pdo->prepare('INSERT INTO tCliente (idCliente, nome, endereco, subRota, pathLogo, responsavel, email, telefone, integrador) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)');
    $pk = pkInfo($pdo, 'tCliente');
    $idCliente = null;
    if ($pk && !$pk['ai']) {
        $idCliente = $pdo->query('SELECT COALESCE(MAX(idCliente),0)+1 AS nx FROM tCliente')->fetch()['nx'] ?? 1;
    }
    $stmt->execute([$idCliente, $_POST['nome'] ?? null, $_POST['endereco'] ?? null, $_POST['subRota'] ?? null, $_POST['pathLogo'] ?? null, $_POST['responsavel'] ?? null, $_POST['email'] ?? null, $_POST['telefone'] ?? null, $_POST['idIntegrador'] ?? null]);
    header('Location: dashboard.php'); exit;
}

// edit_cliente
if ($action === 'edit_cliente') {
    $id = $_POST['idCliente'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare('UPDATE tCliente SET nome=?, endereco=?, subRota=?, pathLogo=?, responsavel=?, email=?, telefone=? WHERE idCliente=?');
        $stmt->execute([$_POST['nome'] ?? null, $_POST['endereco'] ?? null, $_POST['subRota'] ?? null, $_POST['pathLogo'] ?? null, $_POST['responsavel'] ?? null, $_POST['email'] ?? null, $_POST['telefone'] ?? null, $id]);
    }
    header('Location: dashboard.php'); exit;
}

// create_loja
if ($action === 'create_loja') {
    $idCliente = $_POST['idCliente'] ?? null;
    if ($idCliente && ($_POST['descricao'] ?? '')) {
        if (!empty($_POST['cnpj'])) {
            $e = $pdo->prepare('SELECT 1 FROM tLoja WHERE idCliente=? AND cnpj=? LIMIT 1'); $e->execute([$idCliente, $_POST['cnpj']]); $ex = $e->fetch();
        } else {
            $e = $pdo->prepare('SELECT 1 FROM tLoja WHERE idCliente=? AND descricao=? LIMIT 1'); $e->execute([$idCliente, $_POST['descricao']]); $ex = $e->fetch();
        }
        if ($ex) { header('Location: lojas.php?cliente_id=' . urlencode($idCliente) . '&msg=duplicado'); exit; }
        $stmt = $pdo->prepare('INSERT INTO tLoja (idCliente, cnpj, descricao, endereco, pathLogo) VALUES (?, ?, ?, ?, ?)');
        $stmt->execute([$idCliente, $_POST['cnpj'] ?? null, $_POST['descricao'] ?? null, $_POST['endereco'] ?? null, $_POST['pathLogo'] ?? null]);
    }
    header('Location: lojas.php?cliente_id=' . urlencode($idCliente)); exit;
}

// edit_loja
if ($action === 'edit_loja') {
    $id = $_POST['idLoja'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare('UPDATE tLoja SET cnpj=?, descricao=?, endereco=?, pathLogo=? WHERE idLoja=?');
        $stmt->execute([$_POST['cnpj'] ?? null, $_POST['descricao'] ?? null, $_POST['endereco'] ?? null, $_POST['pathLogo'] ?? null, $id]);
        $c = $pdo->prepare('SELECT idCliente FROM tLoja WHERE idLoja=? LIMIT 1'); $c->execute([$id]); $r = $c->fetch();
    }
    header('Location: lojas.php?cliente_id=' . urlencode($r['idCliente'] ?? '')); exit;
}

// create_gondola
if ($action === 'create_gondola') {
    $idLoja = $_POST['idLoja'] ?? null;
    if ($idLoja && ($_POST['descricao'] ?? '')) {
        $e = $pdo->prepare('SELECT 1 FROM tGondola WHERE idLoja=? AND descricao=? LIMIT 1'); $e->execute([$idLoja, $_POST['descricao']]); if ($e->fetch()) { header('Location: gondolas.php?cliente_id=' . urlencode($_POST['idCliente'] ?? '') . '&loja_id=' . urlencode($idLoja) . '&msg=duplicado'); exit; }
        $stmt = $pdo->prepare('INSERT INTO tGondola (idLoja, descricao, modelo, tamanho, setor) VALUES (?, ?, ?, ?, ?)');
        $stmt->execute([$idLoja, $_POST['descricao'] ?? null, $_POST['modelo'] ?? null, $_POST['tamanho'] ?? null, $_POST['setor'] ?? null]);
    }
    header('Location: gondolas.php?cliente_id=' . urlencode($_POST['idCliente'] ?? '') . '&loja_id=' . urlencode($idLoja)); exit;
}

// edit_gondola
if ($action === 'edit_gondola') {
    $id = $_POST['idGondola'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare('UPDATE tGondola SET descricao=?, modelo=?, tamanho=?, setor=? WHERE idGondola=?');
        $stmt->execute([$_POST['descricao'] ?? null, $_POST['modelo'] ?? null, $_POST['tamanho'] ?? null, $_POST['setor'] ?? null, $id]);
        $c = $pdo->prepare('SELECT idLoja FROM tGondola WHERE idGondola=? LIMIT 1'); $c->execute([$id]); $r = $c->fetch();
    }
    header('Location: gondolas.php?cliente_id=' . urlencode($_POST['idCliente'] ?? $r['idCliente'] ?? '') . '&loja_id=' . urlencode($r['idLoja'] ?? $_POST['idLoja'] ?? '')); exit;
}

// create_transmissor
if ($action === 'create_transmissor') {
   try{
        $idGondola = $_POST['idGondola'] ?? null;
        if ($idGondola && ($_POST['descricao'] ?? '')) {
            if (!empty($_POST['codigo'])) {
                $e = $pdo->prepare('SELECT 1 FROM tTransmissor WHERE idGondola=? AND idTransmissor=? LIMIT 1'); $e->execute([$idGondola, $_POST['codigo']]); $ex = $e->fetch();
            } else {
                $e = $pdo->prepare('SELECT 1 FROM tTransmissor WHERE idGondola=? AND descricao=? LIMIT 1'); $e->execute([$idGondola, $_POST['descricao']]); $ex = $e->fetch();
            }
            if ($ex) { header('Location: transmissores.php?cliente_id=' . urlencode($_POST['idCliente'] ?? '') . '&loja_id=' . urlencode($_POST['idLoja'] ?? '') . '&gondola_id=' . urlencode($idGondola) . '&msg=duplicado'); exit; }

            $pk = pkInfo($pdo, 'tTransmissor');
            if ($pk && !$pk['ai']) {
                //$next = $pdo->query('SELECT COALESCE(MAX(idTransmissor),0)+1 AS nx FROM tTransmissor')->fetch()['nx'] ?? 1;
                $stmt = $pdo->prepare('INSERT INTO tTransmissor (idTransmissor, idGondola, posicao, descricao, detalhe, faixaL, faixaH, tipo, alarmeHH, alarmeH, alarmeL, alarmeLL, histerese, notificar, renotificar, estado) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
                $stmt->execute([$_POST['codigo'], $idGondola, $_POST['posicao'] ?? null, $_POST['descricao'] ?? null, $_POST['detalhe'] ?? null, $_POST['faixaL'] ?? null, $_POST['faixaH'] ?? null, $_POST['tipo'] ?? null, $_POST['alarmeHH'] ?? null, $_POST['alarmeH'] ?? null, $_POST['alarmeL'] ?? null, $_POST['alarmeLL'] ?? null, $_POST['histerese'] ?? null, $_POST['notificar'] ?? null, $_POST['renotificar'] ?? null, $_POST['estado'] ?? null]);
            } //else {
            //     $stmt = $pdo->prepare('INSERT INTO tTransmissor (idGondola, posicao, descricao, codigo, caminho, tipo, alarmeHH, alarmeH, alarmeL, alarmeLL, histerese, notificar, renotificar, estado) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
            //     $stmt->execute([$idGondola, $_POST['posicao'] ?? null, $_POST['descricao'] ?? null, $_POST['codigo'] ?? null, $_POST['caminho'] ?? null, $_POST['tipo'] ?? null, $_POST['alarmeHH'] ?? null, $_POST['alarmeH'] ?? null, $_POST['alarmeL'] ?? null, $_POST['alarmeLL'] ?? null, $_POST['histerese'] ?? null, $_POST['notificar'] ?? null, $_POST['renotificar'] ?? null, $_POST['estado'] ?? null]);
            // }
        }
    } catch (Exception $erro) {
        echo "Caught exception: " . $e->getMessage() . "\n";
    } finally {
        header('Location: transmissores.php?cliente_id=' . urlencode($_POST['idCliente'] ?? '') . '&loja_id=' . urlencode($_POST['idLoja'] ?? '') . '&gondola_id=' . urlencode($idGondola)); exit;
    }
}

// edit_transmissor
if ($action === 'edit_transmissor') {
    $id = $_POST['idTransmissor'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare('UPDATE tTransmissor SET posicao=?, descricao=?, detalhe=?, faixaL=?, faixaH=?, tipo=?, alarmeHH=?, alarmeH=?, alarmeL=?, alarmeLL=?, histerese=?, notificar=?, renotificar=?, estado=? WHERE idTransmissor=?');
        $stmt->execute([$_POST['posicao'] ?? null, $_POST['descricao'] ?? null, $_POST['detalhe'] ?? null,$_POST['faixaL'] ?? null, $_POST['faixaH'] ?? null, $_POST['tipo'] ?? null, $_POST['alarmeHH'] ?? null, $_POST['alarmeH'] ?? null, $_POST['alarmeL'] ?? null, $_POST['alarmeLL'] ?? null, $_POST['histerese'] ?? null, $_POST['notificar'] ?? null, $_POST['renotificar'] ?? null, $_POST['estado'] ?? null, $id]);
    }
    header('Location: transmissores.php?cliente_id=' . urlencode($_POST['idCliente'] ?? '') . '&loja_id=' . urlencode($_POST['idLoja'] ?? '') . '&gondola_id=' . urlencode($_POST['idGondola'] ?? '')); exit;
}

// delete endpoints
if ($action === 'delete_loja') { $id = $_GET['loja_id'] ?? null; if ($id) { $stmt = $pdo->prepare('DELETE FROM tLoja WHERE idLoja=?'); $stmt->execute([$id]); } header('Location: dashboard.php'); exit; }
if ($action === 'delete_gondola') { $id = $_GET['gondola_id'] ?? null; if ($id) { $stmt = $pdo->prepare('DELETE FROM tGondola WHERE idGondola=?'); $stmt->execute([$id]); } header('Location: dashboard.php'); exit; }
if ($action === 'delete_cliente') { $id = $_GET['cliente_id'] ?? null; if ($id) { $stmt = $pdo->prepare('DELETE FROM tCliente WHERE idCliente=?'); $stmt->execute([$id]); } header('Location: dashboard.php'); exit; }
if ($action === 'delete_transmissor') { $id = $_GET['id'] ?? null; $cliente = $_GET['cliente_id'] ?? null; $loja = $_GET['loja_id'] ?? null; $gondola = $_GET['gondola_id'] ?? null; if ($id) { $stmt = $pdo->prepare('DELETE FROM tTransmissor WHERE idTransmissor=?'); $stmt->execute([$id]); } header('Location: transmissores.php?cliente_id=' . urlencode($cliente) . '&loja_id=' . urlencode($loja) . '&gondola_id=' . urlencode($gondola)); exit; }

header('Location: dashboard.php'); exit;
?>