<?php
session_start();

function is_logged() {
    return !empty($_SESSION['user']);
}

function require_login() {
    if (!is_logged()) {
        header('Location: login.php');
        exit;
    }
}

function logout() {
    session_unset();
    session_destroy();
}

function generate_form_token() {
    if (!isset($_SESSION['form_tokens'])) $_SESSION['form_tokens'] = [];
    $token = bin2hex(random_bytes(16));
    $_SESSION['form_tokens'][$token] = time();
    if (count($_SESSION['form_tokens']) > 200) {
        $_SESSION['form_tokens'] = array_slice($_SESSION['form_tokens'], -100, 100, true);
    }
    return $token;
}

function validate_form_token($token) {
    if (empty($token)) return false;
    if (!isset($_SESSION['form_tokens'][$token])) return false;
    unset($_SESSION['form_tokens'][$token]);
    return true;
}
?>
