<?php
// utilitário para criar usuário via CLI: php src/create_user.php email senha
if (php_sapi_name() === 'cli') {
    $email = $argv[1] ?? null;
    $senha = $argv[2] ?? null;
    if (!$email || !$senha) {
        echo "Uso: php src/create_user.php email senha\n"; exit;
    }
    require_once __DIR__ . '/db.php';
    $hash = password_hash($senha, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare('INSERT INTO tUsuario (senha, nome, sobrenome, setor, notificar, idTelegram, telefone, email, nivelAcesso) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([$hash, 'Usuário', '', '', 0, null, '', $email, 1]);
    echo "Usuário criado com sucesso.\n"; exit;
} else {
    echo "Este script foi feito para ser executado via linha de comando.\n"; exit;
}
?>
