<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_login();
    $stmt = $pdo->prepare('SELECT * FROM tCliente where idIntegrador = ? ORDER BY idCliente LIMIT 500');
    $stmt->execute([$_SESSION['user']['idIntegrador']]);
    $clientes = $stmt->fetchAll();
$token = generate_form_token();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Dashboard - Clientes <?php echo $_SESSION['user']['nomeCompleto']; ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/public/assets/style.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand bg-white border-bottom mb-3">
  <div class="container-fluid">
    <span class="navbar-brand">KPR - Keepin Remote</span>
    <div class="d-flex">
      <a class="btn btn-outline-secondary btn-sm me-2" href="javascript:location.reload()">Atualizar</a>
      <a class="btn btn-danger btn-sm" href="logout.php">Sair</a>
    </div>
  </div>
</nav>
<div class="container">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Clientes <?php echo $_SESSION['user']['nomeCompleto']; ?> </h4>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNovoCliente">Novo Cliente</button>
  </div>

  <?php if (empty($clientes)): ?>
    <div class="alert alert-info">Nenhum cliente cadastrado.</div>
  <?php endif; ?>

  <div class="row">
    <?php foreach($clientes as $c): ?>
      <div class="col-md-3 mb-3">
        <div class="card h-100">
          <div class="card-body d-flex flex-column">
            <h5 class="card-title"><?=htmlspecialchars($c['nome'] ?? $c['descricao'] ?? 'Cliente')?></h5>
            <p class="card-text"><?=htmlspecialchars($c['endereco'])?></p>
            <p class="card-text"><?=htmlspecialchars($c['responsavel'].' '. $c['telefone'])?></p>
            <div class="mt-auto d-flex gap-2">
              <a href="lojas.php?cliente_id=<?=urlencode($c['idCliente'])?>" class="btn btn-sm btn-outline-primary">Lojas</a>
              <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#modalEditCliente" data-row='<?=htmlspecialchars(json_encode($c), ENT_QUOTES, "UTF-8")?>'>Editar</button>
              <a class="btn btn-sm btn-danger" href="api.php?action=delete_cliente&cliente_id=<?=urlencode($c['idCliente'])?>" onclick="return confirm('Excluir cliente?')">Excluir</a>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Modal Novo Cliente -->
<div class="modal fade" id="modalNovoCliente" tabindex="-1">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="api.php?action=create_cliente" onsubmit="disableSubmit(this)">
      <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>">
      <div class="modal-header"><h5 class="modal-title">Novo Cliente</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
      <div class="modal-body">
        <div class="mb-2"><label class="form-label">nome</label><input name="nome" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">endereco</label><input name="endereco" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">subRota</label><input name="subRota" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">pathLogo</label><input name="pathLogo" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">responsavel</label><input name="responsavel" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">email</label><input name="email" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">telefone</label><input type="number" name="telefone" class="form-control" required></div>
        <input type="hidden" name="idIntegrador" value="<?php echo $_SESSION['user']['idIntegrador']; ?>">
        
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button>
        <button class="btn btn-primary" type="submit">Salvar</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Edit Cliente -->
<div class="modal fade" id="modalEditCliente" tabindex="-1">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="api.php?action=edit_cliente" onsubmit="disableSubmit(this)">
      <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>">
      <input type="hidden" name="idCliente" id="edit_idCliente">
      <div class="modal-header"><h5 class="modal-title">Editar Cliente</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
      <div class="modal-body" id="editClienteBody"></div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button>
        <button class="btn btn-primary" type="submit">Salvar</button>
      </div>
    </form>
  </div>
</div>

<script>
function disableSubmit(form){ const btn = form.querySelector('button[type=submit]'); if(btn){ btn.disabled = true; btn.innerText = 'Enviando...'; } return true; }

document.addEventListener('DOMContentLoaded', function(){
  var editModal = document.getElementById('modalEditCliente');
  var fields = ["idCliente", "nome", "endereco", "subRota", "pathLogo", "responsavel", "email", "telefone"];
  editModal.addEventListener('show.bs.modal', function(e){
    var button = e.relatedTarget;
    var json = button.getAttribute('data-row');
    if(!json) return;
    var obj = JSON.parse(json);
    document.getElementById('edit_idCliente').value = obj.idCliente || obj.id || '';
    var body = document.getElementById('editClienteBody');
    body.innerHTML = '';
    fields.forEach(function(f){
      if (f === 'idCliente') return;
      var val = obj[f] || '';
      var div = document.createElement('div');
      div.className = 'mb-2';
      div.innerHTML = "<label class='form-label'>"+f+"</label><input name='"+f+"' class='form-control' value='"+String(val).replace(/'/g, "&#39;") +"'>";
      body.appendChild(div);
    });
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
