<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_login();
$cliente_id = $_GET['cliente_id'] ?? null;
$loja_id = $_GET['loja_id'] ?? null;
if (!$cliente_id) { header('Location: dashboard.php'); exit; }
$stmt = $pdo->prepare('SELECT * FROM tCliente WHERE idCliente = ? LIMIT 1'); $stmt->execute([$cliente_id]); $cliente = $stmt->fetch(); if (!$cliente) { header('Location: dashboard.php'); exit; }
if (!$loja_id) { header('Location: lojas.php?cliente_id=' . urlencode($cliente_id)); exit; }
$stmt = $pdo->prepare('SELECT * FROM tLoja WHERE idLoja = ? AND idCliente = ? LIMIT 1'); $stmt->execute([$loja_id,$cliente_id]); $loja = $stmt->fetch(); if(!$loja){ header('Location: lojas.php?cliente_id=' . urlencode($cliente_id)); exit; }
$gondolas = $pdo->prepare('SELECT * FROM tGondola WHERE idLoja = ? ORDER BY idGondola'); $gondolas->execute([$loja_id]); $gondolas = $gondolas->fetchAll();
$token = generate_form_token();
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Gôndolas</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body>
<div class="container py-3"><div class="d-flex justify-content-between align-items-center mb-3"><h4>Gôndolas da loja <?=htmlspecialchars($loja['descricao'] ?? '')?></h4><div><a class="btn btn-secondary" href="lojas.php?cliente_id=<?=urlencode($cliente_id)?>">Voltar</a> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNovaGondola">Nova Gôndola</button></div></div>
<?php if(empty($gondolas)): ?><div class="alert alert-info">Nenhuma gôndola cadastrada.</div><?php endif; ?>
<div class="row"><?php foreach($gondolas as $g): ?>
  <div class="col-md-3 mb-3"><div class="card h-100"><div class="card-body d-flex flex-column">
    <h5 class="card-title"><?=htmlspecialchars($g['descricao'] ?? '')?></h5>
    <p class="card-text">ID: <?=htmlspecialchars($g['idGondola'])?></p>
    <div class="mt-auto d-flex gap-2">
      <a href="transmissores.php?cliente_id=<?=urlencode($cliente_id)?>&loja_id=<?=urlencode($loja_id)?>&gondola_id=<?=urlencode($g['idGondola'])?>" class="btn btn-sm btn-outline-primary">Transmissores</a>
      <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#modalEditGondola" data-row='<?=htmlspecialchars(json_encode($g), ENT_QUOTES, "UTF-8")?>'>Editar</button>
      <a class="btn btn-sm btn-danger" href="api.php?action=delete_gondola&gondola_id=<?=urlencode($g['idGondola'])?>" onclick="return confirm('Excluir gôndola?')">Excluir</a>
    </div>
  </div></div></div>
<?php endforeach; ?></div></div>

<!-- Modal Nova Gôndola -->
<div class="modal fade" id="modalNovaGondola" tabindex="-1"><div class="modal-dialog"><form class="modal-content" method="post" action="api.php?action=create_gondola" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idLoja" value="<?=htmlspecialchars($loja_id)?>"><input type="hidden" name="idCliente" value="<?=htmlspecialchars($cliente_id)?>">
  <div class="modal-header"><h5 class="modal-title">Nova Gôndola</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <div class="mb-2"><label class="form-label">Descrição</label><input name="descricao" class="form-control" required></div>
    <div class="mb-2"><label class="form-label">Modelo</label><select name="modelo" class="form-select" required><option value="">Escolha</option><option value="1">Ilha</option><option value="2">Parede</option><option value="3">Genérica</option></select></div>
    <div class="mb-2"><label class="form-label">Tamanho</label><input type="number" name="tamanho" class="form-control" required></div>
    <div class="mb-2"><label class="form-label">Setor</label><input name="setor" class="form-control" required></div>
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<!-- Modal Edit Gondola -->
<div class="modal fade" id="modalEditGondola" tabindex="-1"><div class="modal-dialog"><form class="modal-content" method="post" action="api.php?action=edit_gondola" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idGondola" id="editGondolaId">
  <input type="hidden" name="idCliente" value="<?=htmlspecialchars($cliente_id)?>"><input type="hidden" name="idLoja" value="<?=htmlspecialchars($loja_id)?>">
  <div class="modal-header"><h5 class="modal-title">Editar Gôndola</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body" id="editGondolaBody"></div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<script>
function disableSubmit(form){ const btn = form.querySelector('button[type=submit]'); if(btn){ btn.disabled = true; btn.innerText = 'Enviando...'; } return true; }
document.addEventListener('DOMContentLoaded', function(){
  var editModal = document.getElementById('modalEditGondola');
  editModal.addEventListener('show.bs.modal', function(e){
    var btn = e.relatedTarget;
    var json = btn.getAttribute('data-row'); if(!json) return;
    var obj = JSON.parse(json);
    document.getElementById('editGondolaId').value = obj.idGondola;
    var body = document.getElementById('editGondolaBody'); body.innerHTML = '';
    var fields = ['descricao','modelo','tamanho','setor'];
    fields.forEach(function(f){ var val = obj[f] || ''; var d = document.createElement('div'); d.className='mb-2'; d.innerHTML = "<label class='form-label'>"+f+"</label><input name='"+f+"' class='form-control' value='"+String(val).replace(/'/g, "&#39;")+"'>"; body.appendChild(d); });
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
