<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_login();

$cliente_id = $_GET['cliente_id'] ?? null;
if (!$cliente_id) { header('Location: dashboard.php'); exit; }

$stmt = $pdo->prepare('SELECT * FROM tCliente WHERE idCliente = ? LIMIT 1'); $stmt->execute([$cliente_id]); $cliente = $stmt->fetch();
if (!$cliente) { header('Location: dashboard.php'); exit; }

$stmt = $pdo->prepare('SELECT * FROM tLoja WHERE idCliente = ? ORDER BY idLoja'); $stmt->execute([$cliente_id]); $lojas = $stmt->fetchAll();
$token = generate_form_token();
?>
<!doctype html>
<html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Lojas</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Lojas de <?=htmlspecialchars($cliente['nome'] ?? '')?></h4>
    <div><a class="btn btn-secondary" href="dashboard.php">Voltar</a> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNovaLoja">Nova Loja</button></div>
  </div>
  <?php if (empty($lojas)): ?><div class="alert alert-info">Nenhuma loja cadastrada.</div><?php endif; ?>
  <div class="row">
    <?php foreach($lojas as $l): ?>
      <div class="col-md-3 mb-3">
        <div class="card h-100"><div class="card-body d-flex flex-column">
          <h5 class="card-title"><?=htmlspecialchars($l['descricao'] ?? '')?></h5>
          <h6 class="card-subtitle"><?=htmlspecialchars('CNPJ: '. $l['cnpj'] ?? '')?></h6>
          <p class="card-text"><?=htmlspecialchars($l['endereco'])?></p>
          <div class="mt-auto d-flex gap-2">
            <a href="gondolas.php?cliente_id=<?=urlencode($cliente_id)?>&loja_id=<?=urlencode($l['idLoja'])?>" class="btn btn-sm btn-outline-primary">Gôndolas</a>
            <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#modalEditLoja" data-row='<?=htmlspecialchars(json_encode($l), ENT_QUOTES, "UTF-8")?>'>Editar</button>
            <a class="btn btn-sm btn-danger" href="api.php?action=delete_loja&loja_id=<?=urlencode($l['idLoja'])?>" onclick="return confirm('Excluir loja?')">Excluir</a>
          </div>
        </div></div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Modal Nova Loja -->
<div class="modal fade" id="modalNovaLoja" tabindex="-1"><div class="modal-dialog"><form class="modal-content" method="post" action="api.php?action=create_loja" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idCliente" value="<?=htmlspecialchars($cliente_id)?>">
  <div class="modal-header"><h5 class="modal-title">Nova Loja</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <div class="mb-2"><label class="form-label">CNPJ</label><input type="number" name="cnpj" class="form-control" required></div>
    <div class="mb-2"><label class="form-label">Descrição</label><input name="descricao" class="form-control" required></div>
    <div class="mb-2"><label class="form-label">Endereço</label><input name="endereco" class="form-control" required></div>
    <div class="mb-2"><label class="form-label">PathLogo</label><input name="pathLogo" class="form-control" value="../logo.png"></div>
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<!-- Modal Edit Loja -->
<div class="modal fade" id="modalEditLoja" tabindex="-1"><div class="modal-dialog"><form class="modal-content" method="post" action="api.php?action=edit_loja" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idLoja" id="editLojaId">
  <div class="modal-header"><h5 class="modal-title">Editar Loja</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body" id="editLojaBody"></div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<script>
function disableSubmit(form){ const btn = form.querySelector('button[type=submit]'); if(btn){ btn.disabled = true; btn.innerText = 'Enviando...'; } return true; }
document.addEventListener('DOMContentLoaded', function(){
  var editModal = document.getElementById('modalEditLoja');
  editModal.addEventListener('show.bs.modal', function(e){
    var btn = e.relatedTarget;
    var json = btn.getAttribute('data-row'); if(!json) return;
    var obj = JSON.parse(json);
    document.getElementById('editLojaId').value = obj.idLoja;
    var body = document.getElementById('editLojaBody'); body.innerHTML = '';
    var fields = ['cnpj','descricao','endereco','pathLogo'];
    fields.forEach(function(f){ var val = obj[f] || ''; var d = document.createElement('div'); d.className='mb-2'; d.innerHTML = "<label class='form-label'>"+f+"</label><input name='"+f+"' class='form-control' value='"+String(val).replace(/'/g, "&#39;")+"'>"; body.appendChild(d); });
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
