<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_login();
$cliente_id = $_GET['cliente_id'] ?? null; $loja_id = $_GET['loja_id'] ?? null; $gondola_id = $_GET['gondola_id'] ?? null;
if (!$cliente_id || !$loja_id || !$gondola_id) { header('Location: dashboard.php'); exit; }
$cliente = $pdo->prepare('SELECT * FROM tCliente WHERE idCliente = ? LIMIT 1'); $cliente->execute([$cliente_id]); $cliente = $cliente->fetch();
$loja = $pdo->prepare('SELECT * FROM tLoja WHERE idLoja = ? AND idCliente = ? LIMIT 1'); $loja->execute([$loja_id,$cliente_id]); $loja = $loja->fetch();
$gond = $pdo->prepare('SELECT * FROM tGondola WHERE idGondola = ? AND idLoja = ? LIMIT 1'); $gond->execute([$gondola_id,$loja_id]); $gond = $gond->fetch();
if(!$cliente || !$loja || !$gond){ header('Location: dashboard.php'); exit; }
$trans = $pdo->prepare('SELECT * FROM tTransmissor WHERE idGondola = ? ORDER BY idTransmissor'); $trans->execute([$gondola_id]); $trans = $trans->fetchAll();
$token = generate_form_token();
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Transmissores</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body>
<div class="container py-3"><div class="d-flex justify-content-between align-items-center mb-3"><h4>Transmissores - <?=htmlspecialchars($gond['descricao'] ?? '')?></h4><div><a class="btn btn-secondary" href="gondolas.php?cliente_id=<?=urlencode($cliente_id)?>&loja_id=<?=urlencode($loja_id)?>">Voltar</a> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNovoTransmissor">Novo Transmissor</button></div></div>
<?php if(empty($trans)): ?><div class="alert alert-info">Nenhum transmissor cadastrado.</div><?php endif; ?>
<table class="table table-sm table-bordered"><thead><tr><th>ID</th><th>Posição</th><th>Descrição</th><th>Detalhe</th><th>Faixa</th><th>Alarme</th><th>Ações</th></tr></thead><tbody>
<?php foreach($trans as $t): ?>
  <tr>
    <td><?=htmlspecialchars($t['idTransmissor'])?></td>
    <td><?=htmlspecialchars($t['posicao'] ?? '')?></td>
    <td><?=htmlspecialchars($t['descricao'] ?? '')?></td>
    <td><?=htmlspecialchars($t['detalhe'] ?? '')?></td>
    <td><?=htmlspecialchars($t['faixaL']. ' - '.$t['faixaH'] ?? '')?></td>
    <td><?=htmlspecialchars($t['alarmeHH']. ' - '.$t['alarmeLL']  ?? '')?></td>
    <td>
      <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#modalEditTrans" data-row='<?=htmlspecialchars(json_encode($t), ENT_QUOTES, "UTF-8")?>'>Editar</button>
      <a class="btn btn-sm btn-danger" href="api.php?action=delete_transmissor&id=<?=urlencode($t['idTransmissor'])?>&cliente_id=<?=urlencode($cliente_id)?>&loja_id=<?=urlencode($loja_id)?>&gondola_id=<?=urlencode($gondola_id)?>" onclick="return confirm('Excluir?')">Excluir</a>
    </td>
  </tr>
<?php endforeach; ?>
</tbody></table></div>

<!-- Modal Novo Transmissor -->
<div class="modal fade" id="modalNovoTransmissor" tabindex="-1"><div class="modal-dialog modal-xl"><form class="modal-content" method="post" action="api.php?action=create_transmissor" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idGondola" value="<?=htmlspecialchars($gondola_id)?>"><input type="hidden" name="idCliente" value="<?=htmlspecialchars($cliente_id)?>"><input type="hidden" name="idLoja" value="<?=htmlspecialchars($loja_id)?>">
  <div class="modal-header"><h5 class="modal-title">Novo Transmissor</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <div class="row">
      <div class="col-md-2 mb-2"><label class="form-label">Posição</label><input type="number" name="posicao" class="form-control" value="1" required></div>
      <div class="col-md-4 mb-2"><label class="form-label">Descrição</label><input name="descricao" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Código Transmissor </label><input name="codigo" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Faixa L</label><input type="number" step="0.1" name="faixaL" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Faixa H</label><input type="number" step="0.1" name="faixaH" class="form-control" required></div>
      <div class="col-md-3 mb-2"><label class="form-label">Tipo</label><select  name="tipo" class="form-select" required><option value="">Escolha</option><option value="0">-18ºC a -12ºC</option><option value="1">-12ºC a -5ºC</option><option value="2">-5ºC a 0ºC</option><option value="3">0ºC a 5ºC</option><option value="4">0ºC a 10ºC</option><option value="5">até 16ºC</option><option value="6">Acima 16°C</option></select></div>
      <div class="col-md-2 mb-2"><label class="form-label">Alarme LL</label><input type="number" step="0.1" name="alarmeLL" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Alarme L</label><input type="number" step="0.1" name="alarmeL" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Alarme H</label><input type="number" step="0.1" name="alarmeH" class="form-control" required></div>
      <div class="col-md-2 mb-2"><label class="form-label">Alarme HH</label><input type="number" step="0.1" name="alarmeHH" class="form-control" required></div>
      <div class="col-md-3 mb-2"><label class="form-label">Histerese</label><input type="number" step="0.1" name="histerese" class="form-control" value="0" required></div>
      <div class="col-md-3 mb-2"><label class="form-label">Notificar</label><select name="notificar" class="form-select" required><option value="">Escolha</option><option value="0">Não</option><option value="1">Sim</option></select></div>
      <div class="col-md-3 mb-2"><label class="form-label">Tempo em Horas pra renotificar (h)</label><input type="number" step="0.1" name="renotificar" class="form-control" required></div>
      <div class="col-md-3 mb-2"><label class="form-label">Detalhe (Obs.)</label><input name="detalhe" class="form-control" required></div>
    
    </div>
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<!-- Modal Edit Transmissor -->
<div class="modal fade" id="modalEditTrans" tabindex="-1"><div class="modal-dialog modal-xl"><form class="modal-content" method="post" action="api.php?action=edit_transmissor" onsubmit="disableSubmit(this)">
  <input type="hidden" name="form_token" value="<?=htmlspecialchars($token)?>"><input type="hidden" name="idTransmissor" id="editTransId"><input type="hidden" name="idCliente" value="<?=htmlspecialchars($cliente_id)?>"><input type="hidden" name="idLoja" value="<?=htmlspecialchars($loja_id)?>"><input type="hidden" name="idGondola" value="<?=htmlspecialchars($gondola_id)?>">
  <div class="modal-header"><h5 class="modal-title">Editar Transmissor</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body" id="editTransBody"></div>
  <div class="modal-footer"><button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Fechar</button><button class="btn btn-primary" type="submit">Salvar</button></div>
</form></div></div>

<script>
function disableSubmit(form){ const btn = form.querySelector('button[type=submit]'); if(btn){ btn.disabled = true; btn.innerText = 'Enviando...'; } return true; }

document.addEventListener('DOMContentLoaded', function(){
  var editModal = document.getElementById('modalEditTrans');
  editModal.addEventListener('show.bs.modal', function(e){
    var btn = e.relatedTarget;
    var json = btn.getAttribute('data-row'); if(!json) return;
    var obj = JSON.parse(json);
    document.getElementById('editTransId').value = obj.idTransmissor;
    var body = document.getElementById('editTransBody'); body.innerHTML = '';
    var fields = ['posicao', 'descricao', 'detalhe', 'faixaL', 'faixaH', 'tipo', 'alarmeHH', 'alarmeH', 'alarmeL', 'alarmeLL', 'histerese', 'notificar', 'renotificar', 'estado'];
    fields.forEach(function(f){
      var val = obj[f] || '';
      var d = document.createElement('div'); d.className='mb-2';
      if(f === 'notificar'){
        d.innerHTML = "<label class='form-label'>"+f+"</label><select name='"+f+"' class='form-select'><option value=''>Escolha</option><option value='0'>0</option><option value='1'>1</option></select>";
        // set value after appended
      } else {
        d.innerHTML = "<label class='form-label'>"+f+"</label><input name='"+f+"' class='form-control' value='"+String(val).replace(/'/g, "&#39;") +"'>";
      }
      body.appendChild(d);
    });
    // set select values for notificar
    var sel = body.querySelector('select[name="notificar"]');
    if(sel && obj['notificar'] !== undefined) sel.value = obj['notificar'];
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
